#version 330 core
uniform mat4 ModelViewProjectionMatrix;
uniform mat3 NormalMatrix;
uniform float time;
uniform float z_offset;
uniform vec3  position;

in vec3 POSITION;
in vec3 NORMAL;
in vec2 TEXCOORD;

out vec2 pos_zw;
out vec3 normal;
out vec3 uv_blend;

void main()
{
	vec4 pos = vec4(POSITION , 1.0);
	float blend = 0.0;
	if ( pos.y > 0.1 )
	{
		vec3 offset = vec3(0.0);
		offset.x = sin(time + POSITION.z*1.57)*0.1;
		offset.z = cos(time + POSITION.x*1.57)*0.1;

		pos.xyz += offset;

		float scale = pos.y / 1.25;
		float t = position.z + pos.z - z_offset;
		float shearA = 1.0 - smoothstep(0.0, 1.0, t*0.25);
		float shearB = smoothstep(0.0, 1.0, (t-10.0)*0.25);
		float shearC = smoothstep(0.0, 1.0, (t+8.0)*0.25);
		float shear = shearA*shearC + shearB;
		pos.y -= shear*scale*1.25;
		pos.z += shear*scale*1.25;
		blend = shearC;
	}

	uv_blend.xy = TEXCOORD;
	uv_blend.z = blend;

	normal = NormalMatrix * NORMAL;

	vec4 proj_pos = ModelViewProjectionMatrix * pos;
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
